package gov.va.vamf.scheduling.direct.domain;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name = "validationErrors")
public class ValidationErrors<T> extends ArrayList<ValidationError> implements Serializable {
    private static final long serialVersionUID = -8674522177519030220L;

    private T requestObject;

    public T getRequestObject() {
        return requestObject;
    }

    public void setRequestObject(T requestObject) {
        this.requestObject = requestObject;
    }

    @XmlElement()
    public List<ValidationError> getErrors() {
        return this;
    }

    @XmlElement(name = "object-type")
    public String getObjectType() {
        return this.getClass().getSimpleName();
    }

    public void addIfNotNull(ValidationError e) {
        if (e != null) {
            this.add(e);
        }
    }
}
